<?php

use Core\Database\Migration;
use Core\Database\Schema;
use Core\Database\Table;

return new class implements Migration
{
    /**
     * Jalankan migrasi.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('comments', function (Table $table) {
            $table->addColumn(function ($table) {

                $table->string('parent_id')->nullable();
            });

            $table->foreign('parent_id')->references('uuid')->on('comments')->cascadeOnDelete();
        });
    }

    /**
     * Kembalikan seperti semula.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('comments', function (Table $table) {
            $table->dropForeign('parent_id');
            $table->dropColumn('parent_id');
        });
    }
};
